<?php
	/* 
		WildFire
		v 1.5.1 Build 0001 - 9/08/2012
		Copyright 2012, Firelight Business Enterprises, Inc.
	*/
	class wf_module_string{
		private $installer;

		function __construct(){
			global $installer;
			$this->installer = $installer;
		}

		function wf_module_string(){
			global $installer;
			$this->installer = $installer;
		}

		function kit__generate_string($arguments){
			/*
				{:kit__generate_string[length,type,case,lookalikes]:}
				Returns: string
			*/

			if (!isset($arguments[1])){
				$arguments[1] = "all";
			}
			if (!isset($arguments[2])){
				$arguments[2] = "all";
			}
			if (!isset($arguments[3])){
				$arguments[3] = 0;
			}
	
			if (!$arguments[3]){
				$alpha_pool = "ABCDEFGHJKLMNPQRSTUVWXYZ";
				$number_pool = "23456789";
			}else{
				$alpha_pool = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
				$number_pool = "0123456789";
			}
	
			switch ($arguments[1]){
				case 'alpha':		
				case 'letters':
					$pool[] = $alpha_pool;
				break;
				case 'numeric':
				case 'numbers':
					$pool[] = $number_pool;
				break;
				case 'alpha-numeric':
				case 'all':
				default:
					$pool[] = $alpha_pool;
					$pool[] = $number_pool;
				break;
			}
			$rstring = "";
			for ($i=0;$i<$arguments[0];$i+=1){
				$pool_num = mt_rand(0,count($pool)-1);
				$char = substr($pool[$pool_num],mt_rand(0,strlen($pool[$pool_num])-1),1);
				switch ($arguments[2]){
					case 'lower':
					case 'lowercase':
						$char = strtolower($char);
					break;
					case 'upper':
					case 'uppercase':
						$char = strtoupper($char);
					break;
					case 'mixed':
					case 'both':
					default:
						if (mt_rand(0,1)==0){
							$char = strtolower($char);
						}else{
							$char = strtoupper($char);
						}
					break;			
				}
				$rstring .= $char;
				usleep(15);
			}
			return $rstring;
		}
	
		function kit__generate_password($arguments){
			/*
				{:kit__generate_password[length,alphalower,alphaupper,digits,symbols]:}
				Returns: string
			*/
			// digits
			// alphanumeric
			// symbols
			if (!isset($arguments[0])){
				$arguments[0] = 12;
			}
			if (!isset($arguments[1])){
				$arguments[1] = 1;
			}
			if (!isset($arguments[2])){
				$arguments[2] = 1;
			}
			if (!isset($arguments[3])){
				$arguments[3] = 1;
			}
			if (!isset($arguments[4])){
				$arguments[4] = 0;
			}
			if ($arguments[1]+$arguments[2]+$arguments[3]+$arguments[4]==0){
				$arguments[1] = 1;
				$arguments[2] = 1;
				$arguments[3] = 1;
			}
	
			$tpool[0] = "ABCDEFGHJKMNPQRSTUVWXYZ";
			$tpool[1] = "abcdefghijkmnopqrstuvwxyz";
			$tpool[2] = "23456789";
			$tpool[3] = "!@#$%^&*";
			$password = "";
	
			// Min setup
			for ($j=1;$j<5;$j+=1){
				if ($arguments[$j] > 0){
					for ($i=0;$i<$arguments[$j];$i+=1){
						$password .= substr($tpool[$j-1],mt_rand(0,strlen($tpool[$j-1])-1),1);
						usleep(15);
					}
					$pool[]=$tpool[$j-1];
				}
			}
			
			for ($i=strlen($password);$i<$arguments[0];$i+=1){
				$pool_num = mt_rand(0,count($pool)-1);
				$password .= substr($pool[$pool_num],mt_rand(0,strlen($pool[$pool_num])-1),1);
				usleep(15);
			}
	
			return $password;
		}
		
		function kit__escape_string($arguments){
			/*
				{:kit__escape_string[string]:}
				Returns: string
			*/
			return addslashes($arguments[0]);
		}
	
		function kit__unescape_string($arguments){
			/*
				{:kit__unescape_string[string]:}
				Returns: string
			*/
			return stripslashes($arguments[0]);
		}
	
		function kit__string_length($arguments){
			/*
				{:kit__string_length[string]:}
				Returns: integer
			*/
	
			$total = 0;
			if ($arguments[0]){
				$total = strlen($arguments[0]);
			}
			return $total;
		}

		function kit__replace_string($arguments){
			/*
				{:kit__replace_string[string,search,replace,delimiter,insensitive]:}
				Returns: string
			*/
			if ($arguments[3]){
				$find = explode($arguments[3],$arguments[1]);
				$replace = explode($arguments[3],$arguments[2]);
			}else{
				$find = $arguments[1];
				$replace = $arguments[2];
			}
	
			if ($arguments[4]){
				return str_replace($find, $replace, $arguments[0]);
			}else{
				return str_ireplace($find, $replace, $arguments[0]);
			}	
		}
	
		function get_string_between(&$search_string, $start_string,$end_string){
			$pos = strpos($search_string, $start_string);
			if ($pos === false){
				return "";
			}else{
				return substr($search_string,$pos+strlen($start_string),strpos($search_string,$end_string,$pos+strlen($start_string))-$pos-strlen($start_string));
			}
		}

		function kit__get_string_between($arguments){
			$search_string = $arguments[0];
			$start_string = $arguments[1];
			$end_string = $arguments[2];
			$pos = strpos($search_string, $start_string);
			if ($pos === false){
				return "";
			}else{
				$a= substr($search_string,$pos+strlen($start_string),strpos($search_string,$end_string,$pos+strlen($start_string))-$pos-strlen($start_string));
				return substr($search_string,$pos+strlen($start_string),strpos($search_string,$end_string,$pos+strlen($start_string))-$pos-strlen($start_string));
			}
		}

		function kit__get_string_between_by_variable($arguments){
			$search_string = $this->installer->__kit_vars[$arguments[0]];
			$pos = strpos($this->installer->__kit_vars[$arguments[0]], $arguments[1]);
			if ($pos === false){
				return "";
			}else{
				return substr($this->installer->__kit_vars[$arguments[0]],$pos+strlen($arguments[1]),strpos($this->installer->__kit_vars[$arguments[0]],$arguments[2],$pos+strlen($arguments[1]))-$pos-strlen($arguments[1]));
			}
		}
	}
?>