<?php
	/* 
		WildFire
		v 1.5.0 Build 0005 - 8/20/2012
		Copyright 2012, Firelight Business Enterprises, Inc.
	*/
	class wf_module_kit{
		private $installer;

		function __construct(){
			global $installer;
			$this->installer = $installer;
		}

		function wf_module_kit(){
			global $installer;
			$this->installer = $installer;
		}

		function kit__log($arguments){
			/*
				{:kit__log[logMode,logFile (default logger.log)]:}
				Returns: none
			*/
			$this->installer->__kit_vars["_log"] = $arguments[0];
			if ($arguments[1]){ // Set log filename
				$this->installer->__kit_vars["_log_file"] = $arguments[1];
			}
			if ($arguments[0] != 0){ // AutoStart/AutoEnd Log File
				$this->installer->kit__log_start(array($arguments[1]));
			}
		}
	
		function kit__log_clear($arguments){
			/*
				{:kit__log_clear[logFile (default logger.log)]:}
				Returns: none
			*/
			if ($arguments[0]){ // Delete log filename
				$this->installer->kit__file_delete(array($arguments[0]));
			}else{
				$this->installer->kit__file_delete(array($this->installer->__kit_vars["_log_file"]));
			}
		}
	
		function kit__log_start($arguments=-1){
			/*
				{:kit__log_start[logFile (default {:_log:file:})]:}
				Returns: none
			*/
	
			if ($arguments[0]){
				$log_file = $arguments[0];
			}else{
				$log_file = $this->installer->__kit_vars["_log_file"];
			}

			$file = $this->installer->file_open_write($log_file,'a',1);

			fwrite($file,"------------------------------------------------------------------------\n");
			fwrite($file,date('m-d-Y h:i:s A',time())."\n");
			fwrite($file,"Version ".$this->installer->__kit_vars["_version"]."\n");
			fwrite($file,"Logging Started..."."\n");
			$this->installer->file_close($file);
		}
	
		function kit__log_add($arguments=-1){
			/*
				{:kit__log_add[logMessage,forceLog (default 0), logFile (default {:_log_file:})]:}
				Returns: none
			*/
			if (!isset($arguments[1])){
				$arguments[1] = 0;
			}
			if ($this->installer->__kit_vars["_log"] != 0 || $arguments[1] == 1){
				if (isset($arguments[2]) && $arguments[2]){
					$log_file = $arguments[2];
				}else{
					$log_file = $this->installer->__kit_vars["_log_file"];
				}
				$file = @$this->installer->file_open_write($log_file,'a',1);
				@fwrite($file,"Line ".($this->installer->_current_line+1).": ".$arguments[0]."\n");
				@$this->installer->file_close($file);
			}
		}
	
		function kit__log_end($arguments=-1){
			/*
				{:kit__log_end[logFile (default {:_log_file:})]:}
				Returns: none
			*/
			if ($arguments[0]){
				$log_file = $arguments[0];
			}else{
				$log_file = $this->installer->__kit_vars["_log_file"];
			}
			$file = $this->installer->file_open_write($log_file,'a',1);
			fwrite($file,'Logging Ended...'."\n");
			fwrite($file,date('m-d-Y h:i:s A',time())."\n");
			$this->installer->file_close($file);
		}
	
		function kit__log_dump_variables($arguments){
			/*
				{:kit__log_dump_variables[forceLog (default 0), logFile (default {:_log_file:}), overrideSecure (default 0)]:}
				Returns: none
			*/
			if (!$arguments[0]){
				$arguments[0] = 0;
			}
			if (!$arguments[2]){
				$arguments[2] = 0;
			}
			if ($this->installer->__kit_vars["_log"] != 0 || $arguments[0] == 1){
				$vars_to_copy = $this->installer->__kit_vars;
				if ($arguments[2] == 0){			
					unset($vars_to_copy['cp_serverusername']);
					unset($vars_to_copy['cp_serverpassword']);
					unset($vars_to_copy['cp_serveraccesshash']);
				}
				if ($arguments[1]){
					$log_file = $arguments[1];
				}else{
					$log_file = $this->installer->__kit_vars["_log_file"];
				}
				$file = $this->installer->file_open_write($log_file,'a',1);
				fwrite($file,"* * * Variable Dump * * *"."\n");
				foreach ($vars_to_copy as $key => $value){
					fwrite($file,'    '.$key." = ".$value."\n");
				}
				fwrite($file,"* * * End Variable Dump * * *"."\n");
				$this->installer->file_close($file);
			}
		}
	
		function kit__log_dump_phpinfo($arguments){
			/*
				{:kit__log_dump_phpinfo[forceLog (default 0), logFile (default {:_log_file:})]:}
				Returns: none
			*/
			ob_start();
				phpinfo();
				$contents = ob_get_contents();
			ob_end_clean();
			if (!$arguments[0]){
				$arguments[0] = 0;
			}
			if ($this->installer->__kit_vars["_log"] != 0 || $arguments[0] == 1){
				if ($arguments[1]){
					$log_file = $arguments[1];
				}else{
					$log_file = $this->installer->__kit_vars["_log_file"];
				}
				$file = $this->installer->file_open_write($log_file,'a',1);
				fwrite($file,"* * * PHP Info Dump * * *"."\n");
				fwrite($file,$contents."\n");
				fwrite($file,"* * * End PHP Info Dump * * *"."\n");
				$this->installer->file_close($file);
			}
		}
	}
?>