<?php
	/* 
		WildFire
		mv 0.14 - 2/7/2013
		Copyright 2013, Firelight Business Enterprises, Inc.
	*/
	class wf_module_file{
		private $installer;

		function __construct(){
			global $installer;
			$this->installer = $installer;
		}

		function wf_module_file(){
			global $installer;
			$this->installer = $installer;
		}

		function kit__file_get_string($arguments){
			$file = $this->installer->file_open_get_contents($arguments[0]);
			if (!$file){
				$this->installer->kit__log_add(array("Error opening file - ".$arguments[0]));
				return -1;
			}
			$this->installer->kit__store(array($arguments[1],$file));
			return 1;
		}

		function kit__file_create_unique($arguments){
			do{
				$fn = "";
				for($i=0;$i<$arguments[0];$i++){
					$fn .= mt_rand(0,9);
				}
				$filename = $fn.$arguments[1];
			}while (file_exists($filename));
			$file = $this->installer->file_open_write($filename,'w');
			if (!$file){
				$this->installer->kit__log_add(array("Error creating unique file."));
				return -1;
			}
			$this->installer->file_close($file);
			return $filename;
		}
	
		function kit__ftp_delete_kit_files(){
	
			$this->installer->kit__file_delete_kit_files();
		}	
	
		function kit__file_get_permissions($arguments){
			/*
				{:kit__file_get_permissions[file/folder]:}
				Returns: none
			*/
			$f = fileperms($arguments[0]);
			if ($f){
				return substr(sprintf('%o', $f), -4);
			}else{
				$this->installer->kit__log_add(array("Error getting file permissions."));
			}
		}
	
		function chmod_directory($directory, $value){
			if (substr($directory,-1) == '/'){
				$directory = substr($directory,0,strlen($directory)-1);
			}
			$dhandle = opendir($directory);
			while ($file = readdir($dhandle)){
				if ($file == "." || $file == ".."){
					continue;
				}elseif (is_dir($directory."/".$file)){
					$this->chmod_directory($directory."/".$file,$value);
				}else{
					if (!@chmod($directory."/".$file, octdec($value))){
						// try cpanel
						// cPanel set permissions
						$this->installer->call_function("kit__cpanel_set_file_permissions",array($this->installer->__kit_vars["cp_username"], $this->installer->__kit_vars["cp_password"], $this->installer->__kit_vars["cp_serverip"], $this->installer->__kit_vars["cp_skin"], $directory,$file));
						if ($this->kit__file_get_permissions(array($arguments[0],$arguments[1]) != $arguments[1])){
							$this->installer->kit__log_add(array("Error setting file permissions for $file"));
						}
					}
				}
			}
		}
	
		function kit__file_set_permissions($arguments){
			/*
				{:kit__file_set_permissions[file/folder,mode,subcontents(default 0, 1)]:}
				Returns: none
			*/
			if (!isset($arguments[2])){
				$arguments[2] = 0;
			}
			if ($arguments[2] == 0){
				if (is_dir($arguments[0]) || file_exists($arguments[0])){
					if(!@chmod($arguments[0], octdec($arguments[1]))){
						//cPanel it
						//$this->installer->kit__log_add(array("Error setting file permissions."));
						// cPanel set permissions
						$pathinfo = pathinfo($arguments[0]);
						$dir = substr($this->installer->__kit_vars["_root"],0, -1).$pathinfo['dirname'];
						$file = $pathinfo['basename'];				
						$this->installer->call_function("kit__cpanel_set_file_permissions",array($this->installer->__kit_vars["cp_username"], $this->installer->__kit_vars["cp_password"], $this->installer->__kit_vars["cp_serverip"], $this->installer->__kit_vars["cp_skin"], $dir, $file));
						if ($this->kit__file_get_permissions(array($arguments[0],$arguments[1]) != $arguments[1])){
							$this->installer->kit__log_add(array("Error setting file permissions."));
						}
					}
				}
			}else{
				if (is_dir($arguments[0])){
					$this->chmod_directory($arguments[0],$arguments[1]);
					//exec("chmod -R $arguments[1] $arguments[0] 2>&1", $output, $retval);
				}elseif (file_exists($arguments[0])){
					if(!@chmod($arguments[0], octdec($arguments[1]))){
						// cPanel set permissions
						$pathinfo = pathinfo($arguments[0]);
						$dir = substr($this->installer->__kit_vars["_root"],0, -1).$pathinfo['dirname'];
						$file = $pathinfo['basename'];				
						$this->installer->call_function("kit__cpanel_set_file_permissions",array($this->installer->__kit_vars["cp_username"], $this->installer->__kit_vars["cp_password"], $this->installer->__kit_vars["cp_serverip"], $this->installer->__kit_vars["cp_skin"], $dir, $file));
						if ($this->kit__file_get_permissions(array($arguments[0],$arguments[1]) != $arguments[1])){
							$this->installer->kit__log_add(array("Error setting file permissions."));
						}
					}
				}
			}
		}

		function kit__file_get_owner($arguments){
			/*
				{:kit__file_get_owner[file/folder]:}
				Returns: none
			*/
			$f = fileowner($arguments[0]);
			if ($f){
				$info = posix_getpwuid($f);
				return $info['name'];
			}else{
				$this->installer->kit__log_add(array("Error getting file owner."));
			}
		}
	
		function kit__file_get_group($arguments){
			/*
				{:kit__file_get_group[file/folder]:}
				Returns: none
			*/
			$f = fileowner($arguments[0]);
			if ($f){
				$info = $groupinfo = posix_getgrgid($f);
				return $info['name'];
			}else{
				$this->installer->kit__log_add(array("Error getting file group."));
			}
		}
	
		function kit__file_set_owner($arguments){
			/*
				{:kit__file_set_owner[file/folder,owner,subcontents(default 0, 1)]:}
				Returns: none
			*/
			if (!isset($arguments[2])){
				$arguments[2] = 0;
			}
			if ($arguments[2] == 0){
				if (is_dir($arguments[0]) || file_exists($arguments[0])){
					if (!chown($arguments[1], $arguments[0])){
						$this->installer->kit__log_add(array("Error setting file owner."));
					}
				}
			}else{
				if (is_dir($arguments[0])){
					$this->chown_directory($arguments[0], $arguments[1]);
					//exec("chown -R $arguments[1] $arguments[0] 2>&1", $output, $retval);
				}else{
					if (!chown($arguments[1], $arguments[0])){
						$this->installer->kit__log_add(array("Error setting file owner."));
					}
				}
			}
		}
	
		function kit__file_set_group($arguments){
			/*
				{:kit__file_set_group[file/folder,group,subcontents(default 0, 1)]:}
				Returns: none
			*/
			if (!isset($arguments[2])){
				$arguments[2] = 0;
			}
			if ($arguments[2] == 0){
				if (is_dir($arguments[0]) || file_exists($arguments[0])){
					if (!chgrp($arguments[1], $arguments[0])){
						$this->installer->kit__log_add(array("Error setting file owner."));
					}
				}
			}else{
				if (is_dir($arguments[0])){
					//("chgrp -R $arguments[1] $arguments[0] 2>&1", $output, $retval);
					$this->chgrp_directory($arguments[0],$arguments[1]);
				}else{
					if (!chgrp($arguments[1], $arguments[0])){
						$this->installer->kit__log_add(array("Error setting file owner."));
					}
				}
			}
		}

		function file_replace_serialized($matches){
			if (count($matches) == 1){
				return $this->file_replaced_serialized_new;
			}else{
				// check if serialized data has string
				$find = stripslashes($this->file_replaced_serialized_old);
				
				$offset = 0;
				$count = -1;
				do{
					$count++;
					$pos = strpos($matches[2], $find, $offset);
					if ($pos !== false){
						$offset = $pos+1;
					}

				} while($pos !== false);
				if ($count > 0){
					$length = (strlen($this->file_replaced_serialized_new) - strlen($find))*$count;
					$test = str_replace($find, $this->file_replaced_serialized_new, $matches[2]);
					$i = (int)$matches[1]+$length;
					$new_s = "s:".$i.":".$test.";";
					return $new_s;
				}else{
					return $matches[0];
				}
			}
		}
	
		function kit__file_replace_string($arguments){

			/*
				{:kit__file_replace_string[source_file,destination_file,search,replace,delimiter,insensitive,ignore_serialized]:}
				Returns: none
			*/

			$new_file = $this->installer->file_open_get_contents($arguments[0]);
			if (!isset($arguments[6])){
				$arguments[6] = 0;
			}

			if (!is_null($new_file)){
				if ($arguments[4]){
					$find = explode($arguments[4],$arguments[2]);
					$replace = explode($arguments[4],$arguments[3]);
				}else{
					$find[] = $arguments[2];
					$replace[] = $arguments[3];
				}

				if ($arguments[6] !=1){
					for($i=0,$c=count($find);$i<$c;$i++){
						$this->file_replaced_serialized_old = $find[$i];
						$this->file_replaced_serialized_new = $replace[$i];
						if ($arguments[5]){
							$new_file = preg_replace_callback('/s:([0-9]+):(.*?)";|'.$find[$i].'/s', array($this, 'file_replace_serialized'), $new_file);
						}else{
							$new_file = preg_replace_callback('/s:([0-9]+):(.*?);|'.$find[$i].'/si', array($this, 'file_replace_serialized'), $new_file);
						}
						
					}
				}else{
					if ($arguments[5]){
						$new_file = str_ireplace($find, $replace, $new_file);
					}else{
						$new_file = str_replace($find, $replace, $new_file);
					}
				}

				//$this->installer->kit__file_delete(array($arguments[0]));
				$file = $this->installer->file_open_write($arguments[1],'w');
				fwrite($file,$new_file);
				$this->installer->file_close($file);
			}
		}
	
		function chown_directory($directory, $value){
			if (substr($directory,-1) == '/'){
				$directory = substr($directory,0,strlen($directory)-1);
			}
			$dhandle = opendir($directory);
			while ($file = readdir($dhandle)){
				if ($file == "." || $file == ".."){
					continue;
				}else if (is_dir($directory."/".$file)){
					$this->chown_directory($directory."/".$file,$value);
				}else{
					if (!chown($director."/".$file,$value)){
						$this->installer->kit__log_add(array("Error setting file owner."));
					}
				}
			}
		}
	
		function chgrp_directory($directory, $value){
			if (substr($directory,-1) == '/'){
				$directory = substr($directory,0,strlen($directory)-1);
			}
			$dhandle = opendir($directory);
			while ($file = readdir($dhandle)){
				if ($file == "." || $file == ".."){
					continue;
				}else if (is_dir($directory."/".$file)){
					$this->chgrp_directory($directory."/".$file,$value);
				}else{
					if (!chgrp($director."/".$file,$value)){
						$this->installer->kit__log_add(array("Error setting file group."));
					}
				}
			}
		}
	}
?>