<?php
	/* 
		WildFire
		v 1.5.0 Build 0006 - 03/20/2013
		Copyright 2013, Firelight Business Enterprises, Inc.
	*/
	class wf_module_compression{
		private $installer;

		function __construct(){
			global $installer;
			$this->installer = $installer;
		}

		function wf_module_compression(){
			global $installer;
			$this->installer = $installer;
		}


		function extract_tarball($file){
			$tarstr = $this->installer->file_open_get_contents($this->extract_gzip($file));
			$length = strlen($tarstr);
			$byte = 0;
			$null = 0;
			$byte = 0;
			while ($null <2 && $byte < $length){
				$ret = $this->get_record($tarstr, $byte);
				if ($ret == -1){
					$null +=1;
				}else{
					$byte = $ret;
				}
			}
		}
	
		function get_record(&$tarstr, $byte){
			if (hexdec(substr($tarstr,$byte,512)) == "\0"){
				return -1;
			}
			$name = substr($tarstr,$byte,min(strpos($tarstr,"\0",$byte)-$byte,100));
			$byte+=100;
			$mode = substr($tarstr,$byte,8);
			$byte +=8;
			$uid = substr($tarstr,$byte,8);
			$byte +=8;
			$gid = substr($tarstr,$byte,8);
			$byte +=8;
			$size = octdec(substr($tarstr,$byte,12));
			$byte +=12;
			$mtime = substr($tarstr,$byte,12);
			$byte +=12;
			$header_check = substr($tarstr,$byte,8);
			$byte +=8;
			$link = substr($tarstr,$byte,1);
			$byte +=1;
			$linkname = substr($tarstr,$byte,100);
			$byte +=100;
	
			// add USTAR format... (bleh)
			$byte +=255;
	
			$data = substr($tarstr,$byte,$size);
			// Write file
			$f = $this->file_open_write($name,'w');
			if ($f){
				fwrite($f, $data);
				$this->file_close($f);
			}else{
				$this->installer->kit__log_add(array("Tar - Error opening file $name for writing."));
			}
			$byte +=$size;
	
	
			// Handle padding
			$r= $byte%512;
			if ($r){
				$byte +=512-$r;
			}
			return $byte;
		}
	
		function extract_gzip($file){
			if (file_exists($file)){
				$gzstr = $this->installer->file_open_get_contents($file);
				if(substr($gzstr,0,3)=="\x1f\x8b\x08"){ // Header check
					$flags = ord(substr($gzstr,3,1));
		
					$flgTEXT = $flags&1;
					$flgHCRC = $flags&2;
					$flgEXTRA = $flags&4;
					$flgNAME = $flags&8;
					$flgCOMMENT = $flags&16;
					if ($flags&32 || $flags&64 || $flags&128){
						$this->installer->kit__log_add(array("GZip - Error inflating $file - Unrecognized Header Flag"));
					}
					$mtime = substr($gzstr,4,4);
					$xfl = substr($gzstr,8,1);
					$os = substr($gzstr,9,1);
					$byte = 10;
					if ($flgExtra){
						$si1 = substr($gzstr,$byte,1);
						$si2 = substr($gzstr,$byte+1,1);
						$len = substr($gzstr,$byte+2,2);
						$byte += 4 + $len;
					}
			
					if ($flgNAME){
						$terminate = strpos($gzstr, "\0",$byte);
						$name = substr($gzstr,$byte,$terminate-$byte);
						$byte = $terminate+1;
					}
					if ($flgCOMMENT){
						$terminate = strpos($gzstr, "\0",$byte);
						$comment = substr($gzstr,$byte,$terminate-$byte);
						$byte = $terminate+1;
					}
					if ($flgFHCH){
						$crc16 = substr($gzstr,$byte,2);
						$byte +=2;
					}
					$compressed = substr($gzstr,$byte,-8);
					$data = gzinflate($compressed);
					$crc32 = implode("",unpack("I",substr($gzstr,-8,4)));
					$isize = substr($gzstr,-4,4);
					$check = crc32($data);
					if ($check == $crc32){
						$fid = $this->file_open_write($name,'w');
						if ($fid){
						        fwrite($fid,$data);
							$this->file_close($fid);
							$this->kit__file_delete(array($file));
							return $name;
						}else{
							$this->installer->kit__log_add(array("GZip - Error opening file $name for writing."));
						}
					}else{
						$this->installer->kit__log_add(array("GZip - Error inflating $file - CRC32 sumcheck failed...corrupted data"));
					}
				}else{
					$this->installer->kit__log_add(array("GZip - Error inflating $file - Header check failed."));
				}
			}else{
				$this->installer->kit__log_add(array("GZip - File $file not found"));
			}
		}
	
		function kit__decompress_tarball($arguments){
			/*
				{:kit__decompress_tarball[file]:}
				Returns: none
			*/
			$retval = -1;
			if (function_exists('exec')){
				@exec("tar -x ".$arguments[0], $output, $retval);
			}
			if ($retval !=0){
				if (function_exists('gzinflate') && 1==2){
					$this->extract_tarball($arguments[0]);
				}else{
					$pathinfo = pathinfo($arguments[0]);
					if ($pathinfo['dirname'] != "."){
						$dir = $this->installer->__kit_vars["_root"].$pathinfo['dirname'];
					}else{
						$dir = substr($this->installer->__kit_vars["_kit_dir"],0,-1);
					}
					$file = $pathinfo['basename'];
					$this->installer->call_function("cpanel_extract_archive",array($this->installer->__kit_vars["cp_username"], $this->installer->__kit_vars["cp_password"], $this->installer->__kit_vars["cp_serverip"], $this->installer->__kit_vars["cp_skin"], $dir, $file));
				}			
			}
			$pparts = pathinfo($file);
			if (file_exists($pparts['basename'])){
				$this->file_delete($pparts['basename']);
			}
		}
	
		function kit__decompress_gzip($arguments){
			/*
				{:kit__decompress_gzip[file]:}
				Returns: none
			*/
			$retval = -1;
			if (function_exists('exec')){
				@exec("gzip -dN ".$arguments[0], $output, $retval);
			}
			if ($retval !=0){
				$this->installer->kit__log_add(array("Unzip using cPanel."));
				//cPanel
				$pathinfo = pathinfo($arguments[0]);
				if ($pathinfo['dirname'] != "."){
					$dir = $this->installer->__kit_vars["_root"].$pathinfo['dirname'];
				}else{
					$dir = substr($this->installer->__kit_vars["_kit_dir"],0,-1);
				}
				$file = $pathinfo['basename'];

				$this->installer->call_function("cpanel_api_decompress_zip",array($this->installer->__kit_vars["cp_username"], $this->installer->__kit_vars["cp_password"], $this->installer->__kit_vars["cp_serverip"], $dir, $file));
				$this->installer->kit__file_delete(array($arguments[0]));
			}
		}
	
		function kit__decompress_zip($arguments){
			/*
				{:kit__decompress_zip[file]:}
				Returns: none
			*/
			$retval = -1;
			if (function_exists('exec')){
				$this->installer->kit__log_add(array("Unzip using command line."));
				if (!$arguments[1]){
					$arguments[1] = dirname($arguments[0]);
				}
				@exec("unzip -o $arguments[0] -d $arguments[1]", $output, $retval);
			}
	
			if ($retval !=0){
				$this->installer->kit__log_add(array("Unzip using cPanel."));
				//cPanel
				$pathinfo = pathinfo($arguments[0]);
				if ($pathinfo['dirname'] != "."){
					$dir = $this->installer->__kit_vars["_root"].$pathinfo['dirname'];
				}else{
					$dir = substr($this->installer->__kit_vars["_kit_dir"],0,-1);
				}
				$file = $pathinfo['basename'];

				$this->installer->call_function("cpanel_api_decompress_zip",array($this->installer->__kit_vars["cp_username"], $this->installer->__kit_vars["cp_password"], $this->installer->__kit_vars["cp_serverip"], $dir, $file));
				$this->installer->kit__file_delete(array($arguments[0]));
			}
		}
	}
?>