<?php
	/* 
		WildFire
		v 1.5.0 Build 0005 - 8/20/2012
		Copyright 2012, Firelight Business Enterprises, Inc.
	*/
	class wf_module_cpanel{
		private $installer;

		function __construct(){
			global $installer;
			$this->installer = $installer;
		}

		function wf_module_cpanel(){
			global $installer;
			$this->installer = $installer;
		}

		function kit__cpanel_create_database($arguments){
		    sleep(10);
			$this->kit__cpanel_api_database_create(array($arguments[0], $arguments[1], $arguments[2], $arguments[4]));
		}
	
		function kit__cpanel_create_database_user($arguments){
		    sleep(5);
			$this->kit__cpanel_api_database_add_user(array($arguments[0], $arguments[1], $arguments[2], $arguments[4], $arguments[5]));
		}
	
		function kit__cpanel_assign_database_user($arguments){
		    sleep(5);
			$this->kit__cpanel_api_database_assign_user(array($arguments[0], $arguments[1], $arguments[2], $arguments[5], $arguments[4]));
		}

		function kit__cpanel_api_decompress_zip($arguments){
			/*
				{:kit__cpanel_api_decompress_zip[destination,source]:}
			*/
	
			$args = $this->cpanel_api1_prepare_arguments(array($arguments[3], $arguments[4]));
	
			$args['cpanel_xmlapi_module'] = "Fileman";
			$args['cpanel_xmlapi_func'] = "extractfile";
			$args['cpanel_xmlapi_apiversion'] = 1;
			$this->cpanel_api_query(array($arguments[0],$arguments[1],$arguments[2],"cpanel",$args));
		}
	
		function kit__cpanel_extract_archive($arguments){
			global $installer;
			/*
				{:kit__cpanel_extract_archive[cpanel_user,cpanel_password,cpanel_host,cpanel_skin,directory,file]:}
				Returns: none
			*/
			$cpanel_user = $arguments[0];
			$cpanel_password = $arguments[1];
			$cpanel_host = $arguments[2];
			$cpanel_skin = $arguments[3];
			$dir = $arguments[4];
			$file = $arguments[5];
			$port = ($installer->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
			$host = ($installer->__kit_vars['cp__serversecure']=="on") ? "https" : "http";

			$b = $this->installer->http_get_request("", $cpanel_host, $port, $cpanel_user, $cpanel_password, "/frontend/$cpanel_skin/files/extractfile.html?dir=".$dir."&file=".$file,1);
			if (!$b){
				$this->installer->kit__log_add(array("CPanel - Error extracting archive: Directory - ".$dir." File - ".$file."."));
			}
		}

		function kit__cpanel_set_file_permissions($arguments){
			/*
				{:kit__cpanel_set_file_permissions[cpanel_user,cpanel_password,cpanel_host,cpanel_skin,directory,file,permissions]:}
				Returns: none
			*/
			$cpanel_user = $arguments[0];
			$cpanel_password = $arguments[1];
			$cpanel_host = $arguments[2];
			$cpanel_skin = $arguments[3];
			$dir = $arguments[4];
			$file = $arguments[5];
			$permissions = $arguments[6];
	
			$v1 = substr($permissions,-1,1);
			$v2 = substr($permissions,-2,1);
			$v3 = substr($permissions,-3,1);
		
			if ($v3&4){
				$permission_query .="&ur=4";
			}
			if ($v3&2){
				$permission_query .="&uw=2";
			}
			if ($v3&1){
				$permission_query .="&ux=1";
			}
		
			if ($v2&4){
				$permission_query .="&gr=4";
			}
			if ($v2&2){
				$permission_query .="&gw=2";
			}
			if ($v2&1){
				$permission_query .="&gx=1";
			}
		
			if ($v1&4){
				$permission_query .="&wr=4";
			}
			if ($v1&2){
				$permission_query .="&ww=2";
			}
			if ($v1&1){
				$permission_query .="&wx=1";
			}
			$port = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
			$host = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "https" : "http";
			$b = $this->installer->http_get_request("", $cpanel_host, $port, $cpanel_user, $cpanel_password, "/frontend/$cpanel_skin/files/changeperm.html?doubledecode=1&file=".$file."&udir=".$dir."&dir=".urlencode($dir).$permission_query);
	
			if (!$b){
				$this->installer->kit__log_add(array("CPanel - Error setting permissions: Directory - ".$dir." File - ".$file."."));
			}
		}

		function cpanel_api1_prepare_arguments($arguments){
			for ($i=0, $c=count($arguments);$i<$c;$i++){
				$args["arg-".$i] = $arguments[$i];
			}
			return $args;
		}
	
		function kit__cpanel_api_database_create($arguments){
			/*
				{:kit__cpanel_api_create_database[cpanel_user,cpanel_password,cpanel_host,database_name]:}
			*/
			//error_log("Create Database: ".print_r($arguments, true));
			$this->new_cpanel_api_query_create_database($arguments);
	        
			//$args = $this->cpanel_api1_prepare_arguments(array($arguments[3]));
			//$args['cpanel_xmlapi_module'] = "Mysql";
			//$args['cpanel_xmlapi_func'] = "adddb";
			//$args['cpanel_xmlapi_apiversion'] = 1;
			//$this->cpanel_api_query(array($arguments[0],$arguments[1],$arguments[2],"cpanel",$args));
		}
	
		function kit__cpanel_api_database_add_user($arguments){
			/*
				{:kit__cpanel_api_database_add_user[cpanel_user,cpanel_password,cpanel_host,user_name, user_password]:}
			*/
			//error_log("Add User: ".print_r($arguments, true));
			$this->new_cpanel_api_query_create_user($arguments);
			
			/*$args = $this->cpanel_api1_prepare_arguments(array($arguments[3],$arguments[4]));
			$args['cpanel_xmlapi_module'] = "Mysql";
			$args['cpanel_xmlapi_func'] = "adduser";
			$args['cpanel_xmlapi_apiversion'] = 1;
			$this->cpanel_api_query(array($arguments[0],$arguments[1],$arguments[2],"cpanel",$args));*/
		}
	
		function kit__cpanel_api_database_assign_user($arguments){
			/*
				{:kit__cpanel_api_database_assign_user[cpanel_user,cpanel_password,cpanel_host,database_name, user_name, user_permissions, prefixing]:}
			*/
			//error_log("Add User DB: ".print_r($arguments, true));
			$this->new_cpanel_api_query_add_user_to_db($arguments);
			
			/*// user_permissions is space delimited
			if (!isset($arguments[5])){
				$arguments[5] = "ALL";
			}
			if (!isset($arguments[6])){
				$prefixing = $this->installer->__kit_vars['cp__prefixing'];
			}else{
				$prefixing = $argument[6];
			}
			// Prefixing off
			if ($prefixing == 0){
				$args = $this->cpanel_api1_prepare_arguments(array($arguments[0]."_".$arguments[3],$arguments[0]."_".$arguments[4],$arguments[5]));
			}else{ // Prefixing on
				$args = $this->cpanel_api1_prepare_arguments(array($arguments[3],$arguments[4],$arguments[5]));
			}
			$args['cpanel_xmlapi_module'] = "Mysql";
			$args['cpanel_xmlapi_func'] = "adduserdb";
			$args['cpanel_xmlapi_apiversion'] = 1;
			$this->cpanel_api_query(array($arguments[0],$arguments[1],$arguments[2],"cpanel",$args));
			//$this->kit__cpanel_api_database_update_privileges(array($arguments[0],$arguments[1],$arguments[2]));*/
		}
	
		function kit__cpanel_api_database_update_privileges($arguments){
			/*
				{:kit__cpanel_api_database_update_priveleges[cpanel_user,cpanel_password,cpanel_host]:}
			*/
			$args['cpanel_xmlapi_module'] = "Mysql";
			$args['cpanel_xmlapi_func'] = "updateprivs";
			$args['cpanel_xmlapi_apiversion'] = 1;
			$this->cpanel_api_query(array($arguments[0],$arguments[1],$arguments[2],"cpanel",$args));
		}
	
		function cpanel_api_get_skin($arguments){
			/*
				cpanel_get_skin[cpanel_user,cpanel_password,cpanel_host,account]
			*/
			$args['user'] = $arguments[3];
			$a = $this->cpanel_api_query(array($arguments[0],$arguments[1],$arguments[2],"accountsummary",$args));
			return $a;
		}
	
		function cpanel_api_query($arguments){
			/*
				{:cpanel_api_query[cpanel_user,cpanel_pass,domain,function,query]:}
				Returns: none
			*/
			if (function_exists('curl_setopt')){
				return $this->cpanel_api_curl($arguments);
			}elseif (ini_get('allow_url_fopen')){
				return $this->cpanel_api_fopen($arguments);
			}else{
				$this->installer->kit__log_add(array("cUrl and allow_url_fopen are not available on your server."));
			}
		}
	
		function cpanel_api_curl($arguments) {
			$port = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
			$host = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "https" : "http";
			$api_query = $host."://".$arguments[2].":".$port."/xml-api/".$arguments[3];
			$function_arguments = http_build_query($arguments[4], '', '&');
			$curl = curl_init();		
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0); 	
			curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
			curl_setopt($curl, CURLOPT_POST, 1);
			curl_setopt($curl, CURLOPT_URL, $api_query);
			curl_setopt($curl, CURLOPT_TIMEOUT, 15);
			
			$header[] = "Authorization: Basic " . base64_encode($arguments[0].":".$arguments[1]) . "\r\n" . 
					"Content-Type: application/x-www-form-urlencoded\r\n" . 
					"Content-Length: " . strlen($function_arguments) . "\r\n" . "\r\n" . $function_arguments;
			curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
			$result = curl_exec($curl);
			if ($result == false) {
				$this->installer->kit__log_add(array("cAPI(crl) - ". curl_error($curl)));
			}else{
				$xml = @simplexml_load_string($result);
				if ($xml->data->status){
					$status = $xml->data->status;
				}elseif ($xml->data->result){
					$status = $xml->data->result;
				}elseif ($xml->data->event->result){
					$status = $xml->data->event->result;
				}
				if ($status==0){
					$the_m = trim($xml->data->statusmsg?$xml->data->statusmsg:$xml->data->reason);
					if ($the_m !=""){
						$message = $the_m." (";
						$message .="M: ".$arguments[4]['cpanel_xmlapi_module']." - F: ".$arguments[4]['cpanel_xmlapi_func'].")";
						$this->installer->kit__log_add(array("cAPI - ". $message));
					}
				}		
				return $result;
			}
			curl_close($curl);
		}
	
		function cpanel_api_fopen($arguments){
			$port = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
			$host = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "https" : "http";
			$api_query = $host."://".$arguments[2].":".$port."/xml-api/".$arguments[3];
			$function_arguments = http_build_query($arguments[4], '', '&');
			$options = array(
				'http' => array(
					'allow_self_signed' => true,
					'method' => 'POST',
					'header' => "Authorization: Basic " . base64_encode($arguments[0].":".$arguments[1]) . "\n\r" .
						"Content-Type: application/x-www-form-urlencoded\r\n" .
						"Content-Length: " . strlen($function_arguments) . "\r\n" .
						"\r\n" . $function_arguments
				)
			);
			$context = stream_context_create($options);
			return file_get_contents($api_query, false, $context);
		}
		
		function new_cpanel_api_query_create_database($arguments) {
		    $cpanel_user = $arguments[0];
            $cpanel_pass = $arguments[1];
            $host = $arguments[2];
            $db = $arguments[0].'_'.$arguments[3];
            
            $port = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
			$protocol = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "https" : "http";
			
			if ($host == '189.85.38.13') {
                $host = "server1.adminit.info";
                $port = "2083";
                $protocol = "https";
            }
            
            if ($host == '189.85.38.63') {
                $host = "server.adminit.io";
                $port = "2083";
                $protocol = "https";
            }
            
            if ($host == '189.85.36.56') {
                $host = "server.kit.guru";
                $port = "2083";
                $protocol = "https";
            }
            
            //Example: https://hostname.example.com:20/json-api/cpanel?cpanel_jsonapi_user=user&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=MysqlFE&cpanel_jsonapi_func=createdb&db=example_database
            $api_query = $protocol."://".$host.":".$port."/json-api/cpanel?cpanel_jsonapi_user=".$cpanel_user."&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=MysqlFE&cpanel_jsonapi_func=createdb&db=".$db;
            
            /*$url = $api_query;
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_HEADER, true);    // we want headers
            curl_setopt($ch, CURLOPT_NOBODY, true);    // we don't need body
            curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
            curl_setopt($ch, CURLOPT_TIMEOUT,10);
            $output = curl_exec($ch);
            $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            $this->installer->kit__log_add(array($url.' -> HTTP code: ' . $httpcode));*/
            
            $curl = curl_init(); 
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
            curl_setopt($curl, CURLOPT_HEADER,0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
            $header[0] = "Authorization: Basic " . base64_encode($cpanel_user.":".$cpanel_pass) . "\n\r";
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_URL, $api_query);
            $result = curl_exec($curl);
            if ($result === false) {
                error_log("Error: ".curl_error($curl));
                $this->installer->kit__log_add(array("Error: ".curl_error($curl)));
            }
            //$this->installer->kit__log_add(array("Revisión: ".print_r($result, true)));
            curl_close($curl);
		}
		
		function new_cpanel_api_query_create_user($arguments) {
		    $cpanel_user = $arguments[0];
            $cpanel_pass = $arguments[1];
            $host = $arguments[2];
            $db_user = $arguments[0].'_'.$arguments[3];
            $db_pass = $arguments[4];
            
            $port = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
			$protocol = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "https" : "http";
			
			if ($host == '189.85.38.13') {
                $host = "server1.adminit.info";
                $port = "2083";
                $protocol = "https";
            }
            
            if ($host == '189.85.38.63') {
                $host = "server.adminit.io";
                $port = "2083";
                $protocol = "https";
            }
            
            if ($host == '189.85.36.56') {
                $host = "server.kit.guru";
                $port = "2083";
                $protocol = "https";
            }
            
            //Example: https://hostname.example.com:2087/cpsess###########/json-api/cpanel?cpanel_jsonapi_user=user&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=MysqlFE&cpanel_jsonapi_func=createdbuser&dbuser=example_user1&password=12345luggage
            $api_query = $protocol."://".$host.":".$port."/json-api/cpanel?cpanel_jsonapi_user=".$cpanel_user."&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=MysqlFE&cpanel_jsonapi_func=createdbuser&dbuser=".$db_user."&password=".$db_pass;
            
            $curl = curl_init(); 
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
            curl_setopt($curl, CURLOPT_HEADER,0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
            $header[0] = "Authorization: Basic " . base64_encode($cpanel_user.":".$cpanel_pass) . "\n\r";
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_URL, $api_query);
            $result = curl_exec($curl);
            curl_close($curl);
		}
		
		function new_cpanel_api_query_add_user_to_db($arguments) {
		    $cpanel_user = $arguments[0];
            $cpanel_pass = $arguments[1];
            $host = $arguments[2];
            $db = $arguments[0].'_'.$arguments[3];
            $db_user = $arguments[0].'_'.$arguments[4];
            
            $port = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
			$protocol = ($this->installer->__kit_vars['cp__serversecure']=="on") ? "https" : "http";
			
			if ($host == '189.85.38.13') {
                $host = "server1.adminit.info";
                $port = "2083";
                $protocol = "https";
            }
            
            if ($host == '189.85.38.63') {
                $host = "server.adminit.io";
                $port = "2083";
                $protocol = "https";
            }
            
            if ($host == '189.85.36.56') {
                $host = "server.kit.guru";
                $port = "2083";
                $protocol = "https";
            }
            
            //Example: https://hostname.example.com:2087/cpsess###########/json-api/cpanel?cpanel_jsonapi_user=user&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=MysqlFE&cpanel_jsonapi_func=setdbuserprivileges&db=example_db1&dbuser=example_user1&privileges=UPDATE%2CALTER
            $api_query = $protocol."://".$host.":".$port."/json-api/cpanel?cpanel_jsonapi_user=".$cpanel_user."&cpanel_jsonapi_apiversion=2&cpanel_jsonapi_module=MysqlFE&cpanel_jsonapi_func=setdbuserprivileges&db=".$db."&dbuser=".$db_user."&privileges=ALL%20PRIVILEGES";
            
            $curl = curl_init(); 
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
            curl_setopt($curl, CURLOPT_HEADER,0);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER,1);
            $header[0] = "Authorization: Basic " . base64_encode($cpanel_user.":".$cpanel_pass) . "\n\r";
            curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
            curl_setopt($curl, CURLOPT_URL, $api_query);
            $result = curl_exec($curl);
            curl_close($curl);
		}
	}
?>