<?php
/* 
	Wildfire DSI
	v 1.5.2 Build 0004 - 12/08/2012
	Copyright 2012, Firelight Business Enterprises, Inc.
*/
class kit_installer{

	function check_mapping(){
		if (is_file('/var/cpanel/cpanel.config')){
			$config = file('/var/cpanel/cpanel.config');
			if ($config){
				foreach($config as $key=>$value){
					if(stripos($value,'database_prefix=') === 0){
						$this->__kit_vars['_prefixing'] = substr(trim($value),-1);
					}
				}
			}
		}
	}

	function __construct($parameters=array()){
		set_time_limit(0);
		global $installer;

		error_reporting(0);
		set_error_handler(array("kit_installer", "kit_error"));
		register_shutdown_function(array($this, "kit_fatal_error"));

		// Initialize Directories
		if (substr(getcwd(),-1) == '/'){
			$this->__kit_vars["_parser"] = getcwd();
		}else{
			$this->__kit_vars["_parser"] = getcwd()."/";
		}

		$d1 = explode("/",$_SERVER['SCRIPT_FILENAME']);
		$d2 = explode("/", $_SERVER['PHP_SELF']);
		$d3 = dirname(__FILE__);

		$root = implode("/",array_diff($d1,$d2));
		$basedir = $d3;

		if (substr($root,-1) == '/'){
			$this->__kit_vars["_root"] = $root;
		}else{
			$this->__kit_vars["_root"] = $root."/";
		}
		global $kit_id;

		if (substr($basedir,-1) == '/'){
			$this->__kit_vars["_kit_dir"] = $basedir.$kit_id."/";
		}else{
			$this->__kit_vars["_kit_dir"] = $basedir.$kit_id."/";
		}
		
		$mdir = dirname(__FILE__)."/";

		$this->__kit_vars["_version"] = "1.5.2 ".$vtxt." - Build 0004";
		$this->__kit_vars["_version_type"] = "Full";
		$this->_start_time = time();
		$this->_total_time = 0;
		$this->filepointer = 0;
		$this->filelist = array();
		// Initialize Class
		// ---- Regular Expression Patterns
		$this->regex['comment'] = "/^[#]/i";
		$this->regex['tag'] = "/{:([a-z0-9-_]*)(\[([<>?!@#$%^&*()\'\"~\p{L}0-9-+;`~{}|_=.,\/:\\\ ]*)\]){0,1}:}{1}/i"; // Tag Check
		$this->regex['variable'] = "/[']{1}[$]{1}([a-z0-9-_]*)[']{1}/i"; // Tag Check

		$this->regex['booleans'] = "/(&&)|(\|\|)/i"; // Condition Check
		$this->regex['conditions'] = "/(.*?)(\=+|<|>|<\=|>\=|!\=+|<>)(.*)/i"; // Condition Check

		// Logging Variables
		$this->__kit_vars["_log"] = 0; // Off
		$this->__kit_vars["_log_file"] = "logger.log";

		// Debugging Variables
		$this->__kit_vars["_debug"] = 0; // Off
		$this->__kit_vars["_debug_file"] = "debug.log"; // Off
		$this->_last_line = "";
	}

	function kit_fatal_error(){
		$isError = false;
		if ($error = error_get_last()){
			switch ($error['type']){
				case E_ERROR:
				case E_PARSE:
                case E_CORE_ERROR:
                case E_COMPILE_ERROR:
                case E_USER_ERROR:
                	$isError = true;
                break;
			}
		}
		if ($isError){
			$this->kit__log_add(array("<b>PHP Warning</b> {$error['type']} {$error['message']} on line {$error['line']} in file {$error['file']}"));
		}
	}

	function kit_error($errno, $errstr, $errfile, $errline, $die = false) {
		if ($errno != E_NOTICE){
			//echo "[$errno] $errstr on line $errline in file $errfile<br />";
		}
		if (1==1){//$this->displayErrors ) {
			switch ($errno) {
				/* Custom Errors */
				case E_USER_ERROR:
				break;
				case E_USER_WARNING:
					$this->kit__log_add(array("<b>PHP Warning</b> [$errno] $errstr on line $errline in file $errfile"));
				break;
				case E_USER_NOTICE:
					//$this->kit__log_add(array("<b>PHP Notice</b> [$errno] $errstr on line $errline in file $errfile"));
				break;
				case E_ERROR:
					$this->kit__log_add(array("<b>PHP Error</b> [$errno] $errstr on line $errline in file $errfile"));
					die();
				break;
				case E_WARNING:
					//echo "<b>PHP Warning</b> [$errno] $errstr on line $errline in file $errfile";
					//$this->kit__log_add(array("<b>PHP Warning</b> [$errno] $errstr on line $errline in file $errfile"));
				break;
			}
			return true;
		}
		return false;
	}

	// ----------------------------------------------------------------------------------------------- Begin Special Functions
	// Note - All special functions should begin with kit__ to avoid any *potential* conflicts between functions

	function kit__exit($arguments){
		/*
			{:kit__end[]:}
			Returns: none
		*/
		die('***Early Exit***<br />');
	}

	function file_open_get_contents($file, $type=0){
		if ($file == ""){
			$this->kit__log_add(array("Error opening file for reading - filename is blank."));
			return NULL;
		}
		if (strpos(strtolower($file),"http://") === false && strpos(strtolower($file),"https://") === false){
			$pathinfo = pathinfo($file);
			if ($pathinfo['dirname'] != "."){
				$tdir = $pathinfo['dirname']."/";
				$dir = $this->__kit_vars["_root"].$pathinfo['dirname'];
			}else{
				$tdir = "";
				$dir = substr($this->__kit_vars["_kit_dir"],0,-1);
			}
			$file = $tdir.$pathinfo['basename'];
			// Check if exists
			if (!file_exists($file)){
				$this->kit__log_add(array("File $file does not exist."));
				return NULL;
			}

			// Make readable
			if (!is_readable($file)){
				clearstatcache();
				$old_permissions = $this->kit__file_get_permissions(array($file));
				// Change permissions normal
				@chmod($file, 0777);
				clearstatcache();
				if (!is_readable($file)){
					// Change permissions cPanel
					$this->kit__cpanel_set_file_permissions(array($this->__kit_vars["cp_username"], $this->__kit_vars["cp_password"], $this->__kit_vars["cp_serverip"], $this->__kit_vars["cp_skin"], $dir,$file,'0777'));
					clearstatcache();
					if (!is_readable($file)){
						if (!$log){
							$this->kit__log_add(array("File $file is not readable (permissions)."));
						}
						return -1;
					}
				}
			}
			if ($type == 0){
				$contents = file_get_contents($file);
			}else{
				$contents = file($file);
			}
			
			if (!$contents){
				// Log It
				if (!$log){
					$this->kit__log_add(array("Error opening $file for reading."));
				}
				$contents = "";
			}
			if ($old_permissions){
				$mode = (int)$old_permissions;
				@chmod($file, $mode);
				clearstatcache();
				if ($this->kit__file_get_permissions(array($file)) != $mode){
					$pathinfo = pathinfo($file);
					if ($pathinfo['dirname'] != "."){
						$dir = $this->__kit_vars["_root"].$pathinfo['dirname'];
					}else{
						$dir = substr($this->__kit_vars["_kit_dir"],0,-1);
					}
					$file = $pathinfo['basename'];
					$this->kit__cpanel_set_file_permissions(array($this->__kit_vars["cp_username"], $this->__kit_vars["cp_password"], $this->__kit_vars["cp_serverip"], $this->__kit_vars["cp_skin"], $dir,$file,$mode));
				}
			}
		}else{
			$tags = parse_url($file);
			if (!$tags['port']){
				$tags['port'] = 80;
			}
			if (!$tags['path']){
				$tags['path'] = "/";
			}

			$contents = $this->http_get_request("", $tags['host'], $tags['port'], $tags['user'], $tags['pass'], $tags['path'], 1);

		}

		return $contents;
	}

	function kit__cpanel_create_file($arguments){
		/*
			{:kit__cpanel_delete_file[cpanel_user,cpanel_password,cpanel_host,cpanel_skin,directory,file]:}
			Returns: none
		*/
		// action = domkfile.html
		// dir = home/basic
		// template = text document,HTML document, Perl Script, Shell Script, Text Document
		// newfile = nameoffile
		$cpanel_user = $arguments[0];
		$cpanel_password = $arguments[1];
		$cpanel_host = $arguments[2];
		$cpanel_skin = $arguments[3];
		$dir = $arguments[4];
		$file = $arguments[5];
		$port = ($this->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
		$host = ($this->__kit_vars['cp__serversecure']=="on") ? "https" : "http";
		$b = $this->http_get_request("", $cpanel_host, $port, $cpanel_user, $cpanel_password, "/frontend/$cpanel_skin/files/domkfile.html?dir=".$dir."&newfile=".$file."&template=Text Document");
		if (!$b){
			// Adding to log disallowed here; possible looping
			// $this->kit__log_add(array("CPanel - Error creating file."));
		}
	}

	function kit__cpanel_delete_file($arguments){
		/*
			{:kit__cpanel_delete_file[cpanel_user,cpanel_password,cpanel_host,cpanel_skin,directory,file]:}
			Returns: none
		*/
		$cpanel_user = $arguments[0];
		$cpanel_password = $arguments[1];
		$cpanel_host = $arguments[2];
		$cpanel_skin = $arguments[3];
		$dir = $arguments[4];
		$file = $arguments[5];
		$port = ($this->__kit_vars['cp__serversecure']=="on") ? "2083" : "2082";
		$host = ($this->__kit_vars['cp__serversecure']=="on") ? "https" : "http";
		$b = $this->http_get_request("", $cpanel_host, $port, $cpanel_user, $cpanel_password, "/frontend/$cpanel_skin/files/trashit.html?dir=".$dir."&file=".$file);
		if (!$b){
			$this->kit__log_add(array("CPanel - Error deleting file: Directory - ".$dir." File - ".$file."."));
		}
	}

	function kit__file_delete($arguments){
		if (file_exists($arguments[0])){
			if (!@unlink($arguments[0])){
				// cPanel stylle
				$pathinfo = pathinfo($arguments[0]);
				if ($pathinfo['dirname'] != "."){
					$dir = $this->__kit_vars["_root"].$pathinfo['dirname'];
				}else{
					$dir = substr($this->__kit_vars["_kit_dir"],0,-1);
				}
				$file = $pathinfo['basename'];
				$this->kit__cpanel_delete_file(array($this->__kit_vars["cp_username"], $this->__kit_vars["cp_password"], $this->__kit_vars["cp_serverip"], $this->__kit_vars["cp_skin"], $dir, $file));
				if (file_exists($arguments[0])){
					$this->kit__log_add(array("Error deleting file! - File: $arguments[0]"));
				}
			}
		}
	}

	function file_open_write($file, $mode,$log=0){

		$this->filepointer +=1;

		if ($this->filepointer >=2){
			return -1;
		}

		$pathinfo = pathinfo($file);
		if ($pathinfo['dirname'] != "."){
			$dir = $this->__kit_vars["_root"].$pathinfo['dirname'];
		}else{
			$dir = substr($this->__kit_vars["_kit_dir"],0,-1);
		}
		$cpfile = $pathinfo['basename'];
		clearstatcache();
		// Check if file exists
		if (!file_exists($file)){
			// create file
			$fid = @fopen($file, $mode);
			if (!$fid){
				// create through cPanel
				$this->kit__cpanel_create_file(array($this->__kit_vars["cp_username"], $this->__kit_vars["cp_password"], $this->__kit_vars["cp_serverip"], $this->__kit_vars["cp_skin"], $dir, $cpfile));
				if (!file_exists($file)){
					if (!$log){
						$this->kit__log_add(array("Error opening $file for writing."));
						$this->filepointer -=1;
					}
					return -1;		
				}
			}else{
				return $fid;
			}
		}

		// Check Permissions
		if (!is_writable($file)){
			clearstatcache();
			$old_permissions = $this->kit__file_get_permissions(array($dir."/".$cpfile));
			// Change permissions normal
			@chmod($file, 0777);
			clearstatcache();
			if (!is_writable($file)){
				// Change permissions cPanel
				$this->kit__cpanel_set_file_permissions(array($this->__kit_vars["cp_username"], $this->__kit_vars["cp_password"], $this->__kit_vars["cp_serverip"], $this->__kit_vars["cp_skin"], $dir,$cpfile,'0777'));
				clearstatcache();
				if (!is_writable($file)){
					if (!$log){
						$this->kit__log_add(array("Error opening $file for writing."));
						$this->filepointer -=1;
					}
					return -1;
				}
			}
		}
		$fid = @fopen($file, $mode);
		if (!$fid){
			// Log It
			if (!$log){
				$this->kit__log_add(array("Error opening $file for writing."));
				$this->filepointer -=1;
			}
			return -1;
		}else{
			if ($old_permissions){
				$this->filelist[$fid][0] = $file;
				$this->filelist[$fid][1] = $old_permissions;
			}
		}
		return $fid;
	}

	function file_close($fid){
		if ($this->filelist[$fid]){
			$mode = (int)$this->filelist[$fid][1];
			@chmod($this->filelist[$fid][0], $mode);
			clearstatcache();
			if ($this->kit__file_get_permissions(array($this->filelist[$fid][0])) != $this->filelist[$fid][1]){
				$pathinfo = pathinfo($this->filelist[$fid][0]);
				if ($pathinfo['dirname'] != "."){
					$dir = $this->__kit_vars["_root"].$pathinfo['dirname'];
				}else{
					$dir = substr($this->__kit_vars["_kit_dir"],0,-1);
				}
				$file = $pathinfo['basename'];
				$this->kit__cpanel_set_file_permissions(array($this->__kit_vars["cp_username"], $this->__kit_vars["cp_password"], $this->__kit_vars["cp_serverip"], $this->__kit_vars["cp_skin"], $dir,$file,$this->filelist[$fid][1]));
			}
		}
		fclose($fid);
		$this->filepointer -=1;
	}

	function kit__store($arguments){
		/*
			{:kit__store[variable,value]:}
			Returns: none
		*/
		$this->__kit_vars["$arguments[0]"] = $arguments[1];
	}

	function kit__variable($arguments){
		/*
			{:kit__variable[variable]:}
			*** Use: '$variablename' instead to reference stored variable values
			Returns: variable value
		*/
		if (isset($this->__kit_vars["$arguments[0]"])){
			return $this->__kit_vars["$arguments[0]"];
		}
	}

	function kit__postkit($arguments){
		sleep(5);
		if (function_exists('file_get_contents') && ini_get('allow_url_fopen')){
			/*$this->kit__log_add(array("FGC Attempt: ".$arguments[0]));
			ob_start();
			var_dump($http_response_header);
			$xx = ob_get_contents();
			ob_end_clean();
			$this->kit__log_add(array("FGC Header: ".$xx));
			$this->kit__log_add(array("FGC Contents: ".$x));*/
			$x = file_get_contents($arguments[0]);
		}elseif (function_exists('curl_setopt')){
			//$this->kit__log_add(array("curl Attempt: ".$arguments[0]));
			$curl = curl_init();
	        curl_setopt($curl, CURLOPT_URL, $arguments[0]);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER,0);
			curl_setopt($curl, CURLOPT_SSL_VERIFYHOST,0);
	        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 120);
			curl_setopt($curl,CURLOPT_USERAGENT,'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
	        $result = curl_exec($curl);
	        curl_close($curl);
			if ($result === false) {
				$this->kit__log_add(array("Error opening ".$arguments[0]." - ". curl_error($curl)));
			}else{
			}
		}else{
			//$this->kit__log_add(array("Socket Attempt: ".$arguments[0]));
			$regex = "/(http:\/\/)?(.*?)(\/.*)/i";

			preg_match($regex,$arguments[0],$tags);
			$filep = fsockopen($tags[2], 80, $errn, $errs, 30);
			if (!$filep){
				$this->kit__log_add(array("Error opening postkit file.".$errn." - ".$errs));
			}else{
				$o = "GET ".$tags[3]." HTTP/1.1\r\n";
				$o .= "Host: ".$tags[2]." \r\n";
				$o .= "Connection: Close\r\n\r\n";
				$a = "";
				fwrite($filep, $o);
			    while (!feof($filep)) {
			        fgets($filep, 128);
			    }
				fclose($filep);
			}
		}
	}

	function kit__postkit_fast($arguments){
	    sleep(15);
		$regex = "/(http:\/\/)?(.*?)(\/.*)/i";

		if (!exec("wget '$arguments[0]' -q > /dev/null 2>&1 &")){
			$this->kit__log_add(array("Error opening postkit file: ".$arguments[0]));
			$this->kit__postkit_fast_nuevo($arguments);
		}else{
		}
	}
	
	function kit__postkit_fast_nuevo($arguments){
	    sleep(5);
		$regex = "/(http:\/\/)?(.*?)(\/.*)/i";

		if (!exec("wget '$arguments[0]' -q > /dev/null 2>&1 &")){
			$this->kit__log_add(array("Error opening postkit file: ".$arguments[0]));
			$this->kit__postkit($arguments);
		}else{
		}
	}

	//CPanel

	function http_get_request($scheme="", $host, $port="80", $user="", $password="", $query="/", $results=0){
		$response = "";
		$fsock = @fsockopen($scheme.$host, $port, $errno, $errstr);
		if (!$fsock){
			$this->kit__log_add(array("Unable to connect to $scheme.$host:port - $errstr"));
			return -1;
			fclose($fsock);
		}else{
			$header = "GET $query HTTP/1.1\r\n";
			$header .= "Host: $host:$port\r\n";
			if ($user !=""){
				$header .= "Authorization: Basic " . base64_encode($user.":".$password) . "\r\n";
				$header .= "Content-Type: application/x-www-form-urlencoded\r\n";
			}
			$header .= "Connection: Close\r\n\r\n";

			$results = fwrite($fsock, $header);
			if ($results){
				while (!feof($fsock)){
					$response .= fgets($fsock, 4096);
				}
			}
			fclose($fsock);
			if ($results){
				// Separate header
				$header_end = strpos($response, "\r\n\r\n");
				if ($header_end !== false){
					$header = substr($response,0,$header_end);
					$response = substr($response,$header_end+4,strlen($response)-($header_end+4));
				}
				return $response;
			}else{
				$this->kit__log_add(array("No response from $scheme.$host:port - $query"));
			}
			return 1;
		}
	}

	function kit__dump_variable($arguments){
		$file = $this->file_open_write($arguments[0],'a');
		if (!$file){
			$this->kit__log_add(array("Dump Variables - Error opening file for writing."));
			return;
		}
		fwrite($file,$this->__kit_vars["$arguments[1]"]."\n");
		$this->file_close($file);
	}

	function kit__dump_variables($arguments){
		if (!$arguments[1]){
			$arguments[1] = 0;
		}
		$file = $this->file_open_write($arguments[0],'a');
		if (!$file){
			$this->kit__log_add(array("Dump Variables - Error opening file for writing."));
			return;
		}
		$vars_to_copy = $this->__kit_vars;
		if ($arguments[1] == 0){			
			unset($vars_to_copy['cp_serverusername']);
			unset($vars_to_copy['cp_serverpassword']);
			unset($vars_to_copy['cp_serveraccesshash']);
		}
		fwrite($file,"<?php\n/*\n");
		foreach ($vars_to_copy as $key => $value){
			fwrite($file,$key." = ".$value."\n");
		}
		fwrite($file,"*/\n?>");
		$this->file_close($file);
	}

	function kit__read_variables($arguments){
		$vars = $this->file_open_get_contents($arguments[0],1);
		if (!$vars){
			return;
		}
		$old_vars = $this->__kit_vars;
		$this->__kit_vars = array();
		for ($i=0,$lines = count($vars);$i<$lines;$i++){
			$temp_var = explode(" = ",$vars[$i]);
			$temp_var[0] = trim($temp_var[0]);
			$temp_var[1] = trim($temp_var[1]);
			if ($temp_var[0] != "_root" && $temp_var[0] != "_parser" && $temp_var[0] != "_kit_dir" && $temp_var[0] != "<?php" && $temp_var[0] != "/*" && $temp_var[0] != "*/" && $temp_var[0] != "?>"){
				if ($arguments[1] !=""){
					$this->__kit_vars["$temp_var[0]"] = mb_convert_encoding($temp_var[1], $arguments[1]);
				}else{
					$this->__kit_vars["$temp_var[0]"] = $temp_var[1];
				}
			}
		}
		foreach ($old_vars as $key=>$value){
			if (substr($key,0,1)=="_"){
				$this->__kit_vars["$key"] = $value;
			}
		}
	}
	// ----------------------------------------------------------------------------------------------- End Special Functions

	function add_variable($variable,$value){
		$this->__kit_vars["$variable"] = $value;
	}

	function array_to_variables($variable_array,$oprefix=''){
		if ($oprefix != ""){
			$prefix =$oprefix."_";
		}else{
			$prefix = "";
		}
		if ($variable_array)
		foreach ($variable_array as $key => $value){
			// Check if array
			if (is_array($variable_array[$key])){
				$this->array_to_variables($variable_array[$key],$key);
			}else{
				$this->__kit_vars["$prefix"."$key"] = $value;
			}
		}
	}

	function get_variable($match){
		$variable = $match[1];
		if (isset($this->__kit_vars["$variable"])){
			return $this->__kit_vars["$variable"];
		}else{
			return $match[0];
		}
	}

	function is_conditional($line){
		$is_conditional = 0;

		if (substr(trim($line),0,2) =="if"){
			$is_conditional = 1;
		}

		if (substr(trim($line),0,2) =="do"){
			$is_conditional = 2;
		}

		if (substr(trim($line),0,5) =="while"){
			$is_conditional = 3;
		}

		if (substr(trim($line),0,2) =="/*"){
			$is_conditional = 5;
		}

		return $is_conditional;
	}

	function is_mid_conditional($type, $line){
		$is_conditonal = 0;

		if (substr(trim($line),0,7) =="else if" || substr(trim($line),0,6) =="elseif"){
			if($type==1 || $type==-1){
				$is_conditional = 1;	
			}
		}

		if (substr(trim($line),0,4) =="else"){
			if($type==1 || $type==-1){
				$is_conditional = 1;	
			}
		}
		return $is_conditional;
	}

	function is_end_conditional($type, $line){
		$is_conditional = 0;

		if (substr(trim($line),0,6) =="end if"){
			if ($type==1 || $type==-1){
				$is_conditional = 1;
			}
		}

		/*if (substr(trim($line),0,5) =="while"){
			if ($type==2 || $type==-1){
				$is_conditional = 2;
			}
		}*/

		if (substr(trim($line),0,5) =="until"){
			if ($type==2 || $type==-1){
				$is_conditional = 3;
			}
		}

		if (substr(trim($line),0,9) =="end while"){
			if ($type==3 || $type==-1){
				$is_conditional = 4;
			}
		}

		if (substr(trim($line),-2) =="*/"){
			if ($type==5 || $type==-1){
				$is_conditional = 5;
			}
		}

		return $is_conditional;
	}
	function check_conditions($line){
		$line = trim($line);

		if (substr($line,0,4)=="else"){
			$line = trim(substr($line,4));
		}

		$this->regex['condition_groups'] = "/(\s+\(|\s+|\()(.*)/i"; // Condition Check
		preg_match($this->regex['condition_groups'],$line,$group);
		if ($group[2]){
			if (substr($group[2],-1,1)==")"){
				$group[2] = substr($group[2],0,-1);
			}
		}

		if ($group[2]){
			$conditions = preg_split($this->regex['booleans'],$group[2], -1, PREG_SPLIT_DELIM_CAPTURE+PREG_SPLIT_NO_EMPTY);
			$current_group = 0;
			for ($i=0;$i<count($conditions);$i+=2){
				$the_conditions[$current_group][] = trim($conditions[$i]);
				if (trim($conditions[$i+1]) == "||"){
					$current_group++;
				}
			}
		}

		$flag = 0;
		for ($i=0;$i<count($the_conditions);$i++){
			$condition = 0;
			for ($j=0;$j<count($the_conditions[$i]);$j++){
				preg_match($this->regex['conditions'],$the_conditions[$i][$j],$expression);
				for($k=0;$k<count($expression);$k++){
					$expression[$k] = trim($expression[$k]);
				}

				$expression[1] = trim($this->parse_tag($expression[1],1));
				$expression[3] = trim($this->parse_tag($expression[3],1));

				switch ($expression[2]){
					case '=':
					case '==':
						if ($expression[1]==$expression[3]){
							$condition +=1;
						}
					break;
					case '!=':
						if ($expression[1]!=$expression[3]){
							$condition +=1;
						}
					break;
					case '>':
						if ($expression[1]>$expression[3]){
							$condition +=1;
						}
					break;
					case '<':
						if ($expression[1]<$expression[3]){
							$condition +=1;
						}
					break;
					case '>=':
						if ($expression[1]>=$expression[3]){
							$condition +=1;
						}
					break;
					case '<=':
						if ($expression[1]<=$expression[3]){
							$condition +=1;
						}
					break;
				}
			}
			if ($condition == count($the_conditions[$i])){
				$flag = 1;
				continue;
			}
		}

		return $flag;
	}

	function loop_conditional($condition_type,$ignore=0){
		$mode = 0;
		do{
			switch($mode){
				case 0: // The start
					switch ($condition_type){
						case 1: //If
							if ($ignore==1){
								$mode =3;
							}else{
								$condition_check = $this->check_conditions($this->_kit[$this->_current_line]);
								if ($condition_check == 1){ // found
									$mode = 1;
								}else{
									$mode = 2;
								}
							}
						break;
						case 2: // Do...While
							$last_line = $this->_current_line;
							$mode = 1;
						break;
						case 3: // While...End While
							if ($ignore==1){
								$mode =3;
							}else{
								$condition_check = $this->check_conditions($this->_kit[$this->_current_line]);
								if ($condition_check == 1){ // found
									$last_line = $this->_current_line;
									$mode = 1;
								}else{
									$mode = 2;
								}
							}
						break;
						case 5: // /*...*/
							$mode = 2;
						break;
					}
				break;
				case 1: // Execution
					$val = $this->parse_line($condition_type);
					switch ($val){
						case 1: //IF
							$mode = 3;
							$this->_current_line -=1;
						break;
						case 2: //Do...While
							$mode = 3;
							$this->_current_line -=1;
						break;
						case 3: //While...End While
							$mode = 3;
							$this->_current_line -=1;
						break;
					} 
				break;
				case 2: // Check if next statement
				case 3:
					$condition_type2=$this->is_conditional($this->_kit[$this->_current_line]);
					$end_check2=$this->is_end_conditional($condition_type,$this->_kit[$this->_current_line]);
					if ($mode == 2 && $this->is_mid_conditional($condition_type,$this->_kit[$this->_current_line])){
						$condition_check = $this->check_conditions($this->_kit[$this->_current_line]);
						if ($condition_check == 1){ // found
							$mode = 1;
						}else{
							$mode = 2;
						}
					}elseif ($condition_type2!=0){
						switch ($condition_type2){
							case 1:
								$this->loop_conditional($condition_type2,1);
							break;
						}
					}elseif ($end_check2!=0){
						switch ($condition_type){
							case 1: // If
								$end_check = $condition_type;
								$this->_current_line-=1;
							break;
							case 2: // Do...While
								$condition_check = $this->check_conditions($this->_kit[$this->_current_line]);
								switch ($end_check2){
									case 2: // Do...While
									break;
									case 3: // Do...Until
										$condition_check = 1 - $condition_check;
									break;
								}
								if ($condition_check == 1){ // found
									$this->_current_line = $last_line;
									$mode = 1;
								}else{
									$end_check = $condition_type;
									$this->_current_line-=1;
								}
							break;
							case 3: // While...End While
								if ($mode == 3){
									$this->_current_line = $last_line;
									$mode = 1;
									$this->_current_line-=1;
								}else{
									$end_check = $condition_type;
									$this->_current_line-=1;
								}
							break;
							case 5: // /*...*/
								$end_check = $condition_type;
								$this->_current_line-=1;
							break;
						}
					}else{
					}
				break;
				case 4:
				break;
			}
			$this->_current_line++;
		}while($end_check!=$condition_type && $this->_current_line<$this->_lines);
		if ($this->__kit_vars["_debug"] !=0 && trim($this->_kit[$this->current_line]) !=""){
			$debug_line = trim($this->_kit[$this->_current_line]);
			$this->kit__log_add(array($debug_line, 1, $this->__kit_vars["_debug_file"]));
		}
	}

	function parse_line($conditional=0){
		if ($this->__kit_vars["_debug"] !=0){
			$debug_line = trim($this->_kit[$this->_current_line]);
			$this->kit__log_add(array($debug_line, 1, $this->__kit_vars["_debug_file"]));
		}
		$this->_last_line = trim($this->_kit[$this->_current_line]);
		$condition_type=$this->is_conditional($this->_kit[$this->_current_line]);
		// Ignore All Comments
		if (preg_match($this->regex['comment'],trim($this->_kit[$this->_current_line]))){
		}elseif ($condition_type!=0){
			$this->loop_conditional($condition_type);
		}elseif ($conditional!=0){
			switch ($conditional){
				case 1: // If
					if ($this->is_end_conditional(-1, $this->_kit[$this->_current_line])){
						return 1;
					}elseif ($this->is_mid_conditional(-1, $this->_kit[$this->_current_line])){
						return 1;
					}else{
						$this->parse_tag(trim($this->_kit[$this->_current_line]));
					}
				break;
				case 2: // Do...While
					if ($this->is_end_conditional($conditional, $this->_kit[$this->_current_line])){
						return 2;
					}else{
						$this->parse_tag(trim($this->_kit[$this->_current_line]));
					}
				break;
				case 3: // While...End While
					if ($this->is_end_conditional($conditional, $this->_kit[$this->_current_line])){
						return 3;
					}else{
						$this->parse_tag(trim($this->_kit[$this->_current_line]));
					}
				break;
				case 5: // /*...*/
					if ($this->is_end_conditional($conditional, $this->_kit[$this->_current_line])){
						return 5;
					}else{
						//$this->parse_tag(trim($this->_kit[$this->_current_line]));
					}
				break;
			}
		}else{
			$this->parse_tag(trim($this->_kit[$this->_current_line]));
		}
	}

	function parse($kit){
		$this->_kit = $kit;
		for ($this->_current_line=0,$this->_lines = count($this->_kit);$this->_current_line<$this->_lines;$this->_current_line++){
			$this->parse_line();
		}
	}

	function parse_kit($kit_name){

		// Setup working directory
		$this->old_directory = getcwd();
		chdir(dirname(__FILE__));
		$kit = file($kit_name);
		if (!$kit){
			$this->kit__log_add(array("Parse Kit - Kit does not exist."));
			return;
		}
		// Loop and Parse
		$this->parse($kit);

		// End logging, if enabled
		if ($this->__kit_vars["_log"] != 0){ // End Log File
			$this->kit__log_end();
		}
		if ($this->__kit_vars["_debug"] != 0){ // End Log File
			$this->call_function("debug_end");
		}
	}

	function parse_kit_default($kit_name, $kit_id){
		// Grab cPanel skin
		if ($this->__kit_vars['skin'] = ""){
			//$this->cpanel_api_get_skin(array($this->__kit_vars["cp_username"],$this->__kit_vars["cp_password"],$this->__kit_vars["cp_serverip"],$this->__kit_vars["cp_username"]));
		}

		// Setup working directory
		$this->old_directory = getcwd();
		if (!chdir(dirname(__FILE__)."/".$kit_id)){
			$this->kit__log_add(array("Kit Directory does not exist."));
		}

		$kit = file($kit_name);
		if (!$kit){
			$this->kit__log_add(array("Kit does not exist;."));
		}

		// Loop and Parse
		$this->parse($kit);

		// End logging, if enabled
		if ($this->__kit_vars["_log"] != 0){ // End Log File
			$this->kit__log_end();
		}
		if ($this->__kit_vars["_debug"] != 0){ // End Log File
			$this->call_function("debug_end");
		}
	}

	function kit__parse_file($arguments){

		$temp_kit = new kit_installer();
		$temp_kit->functions = $this->functions;
		$temp_kit->module = $this->module;

		$temp_root = $temp_kit->__kit_vars["_root"];
		$temp_parser = $temp_kit->__kit_vars["_parser"];
		$temp_kit->array_to_variables($this->__kit_vars);

		// Reset root and parser variables
		$temp_kit->__kit_vars["_root"] = $temp_root;
		$temp_kit->__kit_vars["_parser"] = $temp_parser;

		$new_file = "";
		$kit = file($arguments[0]);
		// Loop and Parse
		for ($i=0,$lines = count($kit);$i<$lines;$i++){
			// Ignore All Comments
			if (preg_match($temp_kit->regex['comment'],$kit[$i])){
				$next_line = $kit[$i];
			}else{
				$next_line =$temp_kit->parse_file_tag($kit[$i],1);
			}
			$new_file .=$next_line;
			if ($i <= $lines){
				//$new_file.="\n";
			}
		}
		$this->kit__file_delete(array($arguments[0]));
		if (!file_exists($arguments[1])) {
		    $file = $this->file_open_write($arguments[1],'w');
    		fwrite($file,$new_file);
    		$this->file_close($file);
		}
	}

	function parse_tag($line,$output=0){
		// Explode Variables
		$this->regex['variable'] = "/[']{1}(?:[^\\\\]|\$.)([a-z0-9-_]*)[']{1}/i"; // Tag Check
		$line = preg_replace_callback($this->regex['variable'], array($this,'get_variable'),$line);

		if ($this->__kit_vars["_debug"] !=0 && trim($line)!=$this->_last_line){
			//$this->_last_line = trim($line);
			$this->kit__log_add(array(trim($line), 1, $this->__kit_vars["_debug_file"]));
		}
		// Check for tag
		do{
			$check = preg_match($this->regex['tag'],$line,$match);

			if ($check){
				$line_function = $match[1];

				if (isset($match[3])){
					preg_match_all("/\\,((?:[^\\\\,]|\\\\.)*)/", ",$match[3]", $arguments, PREG_PATTERN_ORDER);
					$arguments = $arguments[1];
				}else{
					$arguments = array();
				}

				// Check if function exist
				foreach($arguments as $key=>&$value){
					$arguments[$key] = preg_replace("/\\\\,/",",", trim($value));
				}

				unset($returned);
				global $installer;

				if ($this->functions["kit__".$line_function]){
					$module = $this->functions["kit__".$line_function];
					$returned = call_user_func(array($this->module[$module],"kit__".$line_function), $arguments);
				}else{
					if (is_callable(array($this,"kit__".$line_function))){
						$returned = call_user_func(array($this,"kit__".$line_function),$arguments);
					}else{
						$this->kit__log_add(array("The function ".$line_function." does not exist."));
					}
				}

				if (isset($returned)){
					$replace = $returned;
				}else{
					$replace = "";
				}
				$line = preg_replace($this->regex['tag'], $replace, $line);
				$new_line = $line;
			}else{
				if ($output == 0){
					// Unescape
					$line = preg_replace("/(\\\\){1}([:]){1}/e","'\\2'",$line);
					$line = preg_replace("/(\\\\){1,}/e","str_repeat('\\\\\',ceil(strlen('\\0')/2))",$line);
				}else{
					//$new_line = trim($line);
					$new_line = $line;
				}
				$line = '';
			}
		}while ($check);
		if ($output == 1){
			//$new_line = preg_replace("/\\\\(.)/s", "$1", $new_line);
			return $new_line;
		}
		// Debugging only
		if ($output == 2 || $this->_dev_mode == 1){
			if ($new_line){
				echo $new_line."<br />";
			}
		}

		$this->_end_time = time();
		$total_time = $this->_end_time - $this->_start_time;
		$this->_total_time += $total_time;
		if ($this->__kit_vars["_debug"] ==2){
			$debug_line = "Execution Time: ".number_format(($this->_end_time - $this->_start_time),4,".","")."/".number_format($this->_total_time,4,".","");;
			$this->kit__log_add(array($debug_line, 1, $this->__kit_vars["_debug_file"]));
		}
		$this->_start_time = time();
	}

	function call_function($line_function, $arguments=array(), $auto_prepend=1){
		if ($auto_prepend == 1){
			$func = "kit__".$line_function;
		}else{
			$func = $line_function;	
		}
		if ($this->functions[$func]){
			$module = $this->functions[$func];
			$returned = call_user_func(array($this->module[$module],$func), $arguments);
		}else{
			if (is_callable(array($this,$func))){
				$returned = call_user_func(array($this,$func),$arguments);
			}else{
				$this->kit__log_add(array("The function ".$func." does not exist."));
			}
		}
	}

	function parse_file_tag($line,$output=0){
		// Explode Variables
		$this->regex['variable'] = "/[']{1}(?:[^\\\\]|\$.)([a-z0-9-_]*)[']{1}/i"; // Tag Check
		$line = preg_replace_callback($this->regex['variable'], array($this,'get_variable'),$line);

		// Check for tag
		$new_line = $line;

		do{
			$check = preg_match($this->regex['tag'],$line,$match);
			if ($check){
				$line_function = $match[1];
				if (isset($match[3])){
					preg_match_all("/\\,((?:[^\\\\,]|\\\\.)*)/", ",$match[3]", $arguments, PREG_PATTERN_ORDER);
					$arguments = $arguments[1];
				}else{
					$arguments = array();
				}

				foreach($arguments as $key=>&$value){
					$arguments[$key] = preg_replace("/\\\\,/",",", trim($value));
				}


				// Check if function exist

				unset($returned);
				global $installer;

				if ($this->functions["kit__".$line_function]){
					$module = $this->functions["kit__".$line_function];
					$returned = call_user_func(array($this->module[$module],"kit__".$line_function), $arguments);
				}else{
					if (is_callable(array($this,"kit__".$line_function))){
						$returned = call_user_func(array($this,"kit__".$line_function),$arguments);
					}else{
						$this->kit__log_add(array("The function ".$line_function." does not exist."));
					}
				}

				if (isset($returned)){
					$replace = $returned;
				}else{
					$replace = "";
				}
				$line = preg_replace($this->regex['tag'], $replace, $line);
				$new_line = $line;
			}else{
				if ($output == 0){
					// Unescape
					//$line = preg_replace("/(\\\\){1}([:]){1}/e","'\\2'",$line);
					//$line = preg_replace("/(\\\\){1,}/e","str_repeat('\\\\\',ceil(strlen('\\0')/2))",$line);
				}else{
					//$new_line = trim($line);
					$new_line = $line;
				}
				$line = '';
			}
		}while ($check);

		if ($output == 1){
			//$new_line = preg_replace("/\\\\(.)/s", "$1", $new_line);
			return $new_line;
		}
		// Debugging only
		if ($output == 2){
			//$new_line = preg_replace("/\\\\(.)/s", "$1", $new_line);
			echo $new_line;
		}
	}

	function shutdown(){
		// Restore error handler
		restore_error_handler();
		// Revert current directory
		chdir($this->old_directory);
	}


	function kit__log($arguments){
		/*
			{:kit__log[logMode,logFile (default logger.log)]:}
			Returns: none
		*/
		$this->__kit_vars["_log"] = $arguments[0];
		if ($arguments[1]){ // Set log filename
			$this->__kit_vars["_log_file"] = $arguments[1];
		}
		if ($arguments[0] != 0){ // AutoStart/AutoEnd Log File
			$this->kit__log_start(array($arguments[1]));
		}
	}

	function kit__log_clear($arguments){
		/*
			{:kit__log_clear[logFile (default logger.log)]:}
			Returns: none
		*/
		if ($arguments[0]){ // Delete log filename
			$this->kit__file_delete(array($arguments[0]));
		}else{
			$this->kit__file_delete(array($this->__kit_vars["_log_file"]));
		}
	}

	function kit__log_start($arguments=-1){
		/*
			{:kit__log_start[logFile (default {:_log:file:})]:}
			Returns: none
		*/

		if ($arguments[0]){
			$log_file = $arguments[0];
		}else{
			$log_file = $this->__kit_vars["_log_file"];
		}

		$file = $this->file_open_write($log_file,'a',1);

		fwrite($file,"------------------------------------------------------------------------\n");
		fwrite($file,date('m-d-Y h:i:s A',time())."\n");
		fwrite($file,"Version ".$this->__kit_vars["_version"]."\n");
		fwrite($file,"Logging Started..."."\n");
		$this->file_close($file);
	}

	function kit__log_add($arguments=-1){

		/*
			{:kit__log_add[logMessage,forceLog (default 0), logFile (default {:_log_file:})]:}
			Returns: none
		*/
		if (!isset($arguments[1])){
			$arguments[1] = 0;
		}
		if ($this->__kit_vars["_log"] != 0 || $arguments[1] == 1){				
			if (isset($arguments[2]) && $arguments[2]){
				$log_file = $arguments[2];
			}else{
				$log_file = $this->__kit_vars["_log_file"];
			}
			$file = @$this->file_open_write($log_file,'a',1);
			@fwrite($file,"Line ".($this->_current_line+1).": ".$arguments[0]."\n");
			@$this->file_close($file);
		}
	}

	function kit__log_end($arguments=-1){
		/*
			{:kit__log_end[logFile (default {:_log_file:})]:}
			Returns: none
		*/
		if ($arguments[0]){
			$log_file = $arguments[0];
		}else{
			$log_file = $this->__kit_vars["_log_file"];
		}
		$file = $this->file_open_write($log_file,'a',1);
		fwrite($file,'Logging Ended...'."\n");
		fwrite($file,date('m-d-Y h:i:s A',time())."\n");
		$this->file_close($file);
	}

	function kit__log_dump_variables($arguments){
		/*
			{:kit__log_dump_variables[forceLog (default 0), logFile (default {:_log_file:}), overrideSecure (default 0)]:}
			Returns: none
		*/
		if (!$arguments[0]){
			$arguments[0] = 0;
		}
		if (!$arguments[2]){
			$arguments[2] = 0;
		}
		if ($this->__kit_vars["_log"] != 0 || $arguments[0] == 1){
			$vars_to_copy = $this->__kit_vars;
			if ($arguments[2] == 0){			
				unset($vars_to_copy['cp_serverusername']);
				unset($vars_to_copy['cp_serverpassword']);
				unset($vars_to_copy['cp_serveraccesshash']);
			}
			if ($arguments[1]){
				$log_file = $arguments[1];
			}else{
				$log_file = $this->__kit_vars["_log_file"];
			}
			$file = $this->file_open_write($log_file,'a',1);
			fwrite($file,"* * * Variable Dump * * *"."\n");
			foreach ($vars_to_copy as $key => $value){
				fwrite($file,'    '.$key." = ".$value."\n");
			}
			fwrite($file,"* * * End Variable Dump * * *"."\n");
			$this->file_close($file);
		}
	}

	function kit__log_dump_phpinfo($arguments){
		/*
			{:kit__log_dump_phpinfo[forceLog (default 0), logFile (default {:_log_file:})]:}
			Returns: none
		*/
		ob_start();
			phpinfo();
			$contents = ob_get_contents();
		ob_end_clean();
		if (!$arguments[0]){
			$arguments[0] = 0;
		}
		if ($this->__kit_vars["_log"] != 0 || $arguments[0] == 1){
			if ($arguments[1]){
				$log_file = $arguments[1];
			}else{
				$log_file = $this->__kit_vars["_log_file"];
			}
			$file = $this->file_open_write($log_file,'a',1);
			fwrite($file,"* * * PHP Info Dump * * *"."\n");
			fwrite($file,$contents."\n");
			fwrite($file,"* * * End PHP Info Dump * * *"."\n");
			$this->file_close($file);
		}
	}

	function kit__file_delete_kit_files(){

		$kit_files[] = "kit_parser.php";
		$kit_files[] = "postkit.php";
		$kit_files[] = "postkit.kit";
		$kit_files[] = "kit_vars.txt";
		$kit_files[] = "debug.log";
		$kit_files[] = "logger.log";
		if (isset($this__kit_vars["variable_file"])){
			if (file_exists($this->__kit_vars["variable_file"])){
				$kit_files[] = $this->__kit_vars["variable_file"];
			}
		}

		for($i=0,$c=count($kit_files);$i<$c;$i++){
			$this->kit__file_delete(array($kit_files[$i]));
		}

		//Modules Folder
		$old_dir = getcwd();
		if (@chdir(getcwd()."/"."wildfire_modules")){
			$d = dir(getcwd());
			while (false !== ($entry = $d->read())){
				if ($entry !="." && $entry !=".."){
					$this->kit__file_delete(array($entry));
				}
			}
			@chdir($old_dir);
			@rmdir("wildfire_modules");
		}
	}
	
	function kit__file_get_permissions($array = false) {
	    return false;
	}
	function kit__cpanel_set_file_permissions($array = false) {
	    return false;
	}
}
?>